namespace MSPetShopClasses {
    using System;
    using System.ComponentModel;
    using System.Collections;
    using Borland.Eco.Services;
    using Borland.Eco.ObjectRepresentation;
    using Borland.Eco.ObjectImplementation;
    using Borland.Eco.UmlRt;
    using Borland.Eco.UmlCodeAttributes;

	[UmlCollection(typeof(Supplier))]
	public interface ISupplierList : ICollection
	{
		#region ECO generated code
		Supplier this[int index]
		{
			get;
			set;
		}
		int Add(Supplier value);
		bool Contains(Supplier value);
		int IndexOf(Supplier value);
		void Insert(int index, Supplier value);
		void Remove(Supplier value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Product))]
	public interface IProductList : ICollection
	{
		#region ECO generated code
		Product this[int index]
		{
			get;
			set;
		}
		int Add(Product value);
		bool Contains(Product value);
		int IndexOf(Product value);
		void Insert(int index, Product value);
		void Remove(Product value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Item))]
	public interface IItemList : ICollection
	{
		#region ECO generated code
		Item this[int index]
		{
			get;
			set;
		}
		int Add(Item value);
		bool Contains(Item value);
		int IndexOf(Item value);
		void Insert(int index, Item value);
		void Remove(Item value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Inventory))]
	public interface IInventoryList : ICollection
	{
		#region ECO generated code
		Inventory this[int index]
		{
			get;
			set;
		}
		int Add(Inventory value);
		bool Contains(Inventory value);
		int IndexOf(Inventory value);
		void Insert(int index, Inventory value);
		void Remove(Inventory value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Category))]
	public interface ICategoryList : ICollection
	{
		#region ECO generated code
		Category this[int index]
		{
			get;
			set;
		}
		int Add(Category value);
		bool Contains(Category value);
		int IndexOf(Category value);
		void Insert(int index, Category value);
		void Remove(Category value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Profile))]
	public interface IProfileList : ICollection
	{
		#region ECO generated code
		Profile this[int index]
		{
			get;
			set;
		}
		int Add(Profile value);
		bool Contains(Profile value);
		int IndexOf(Profile value);
		void Insert(int index, Profile value);
		void Remove(Profile value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(SignOn))]
	public interface ISignOnList : ICollection
	{
		#region ECO generated code
		SignOn this[int index]
		{
			get;
			set;
		}
		int Add(SignOn value);
		bool Contains(SignOn value);
		int IndexOf(SignOn value);
		void Insert(int index, SignOn value);
		void Remove(SignOn value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Account))]
	public interface IAccountList : ICollection
	{
		#region ECO generated code
		Account this[int index]
		{
			get;
			set;
		}
		int Add(Account value);
		bool Contains(Account value);
		int IndexOf(Account value);
		void Insert(int index, Account value);
		void Remove(Account value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="beabaf2b-6b4c-46c8-9f4e-32cf2d15a52b")]
	[UmlMetaAttribute("ownedElement", typeof(Account))]
	[UmlMetaAttribute("ownedElement", typeof(Category))]
	[UmlMetaAttribute("ownedElement", typeof(Inventory))]
	[UmlMetaAttribute("ownedElement", typeof(Item))]
	[UmlMetaAttribute("ownedElement", typeof(Product))]
	[UmlMetaAttribute("ownedElement", typeof(Profile))]
	[UmlMetaAttribute("ownedElement", typeof(SignOn))]
	[UmlMetaAttribute("ownedElement", typeof(Supplier))]
	[EcoCodeGenVersion("2.0")]
    public class MSPetShopClassesPackage {

        [UmlElement("Association", Id="a10f40dd-39c6-48cf-a9e0-d3964ab552d3")]
		public class CategoryProducts
		{
		}

		[UmlElement("Association", Id="5dcec30e-02be-4a6f-afeb-84a9dee0923e")]
		public class Association_1
		{
		}

		[UmlElement("Association", Id="11d4d4db-1b15-4430-9161-421253726148")]
		public class Association_2
		{
		}

		[UmlElement("Association", Id="84c54d05-b27b-4f2d-bbb5-a36b52671edc")]
		public class Association_3
		{
		}

		[UmlElement("Association", Id="15eb8430-6d05-4d64-80fa-e1541bc77bde")]
		public class Association_5
		{
		}

		[UmlElement("Association", Id="751c702b-0e64-480d-8fa1-63937905083e")]
		public class Association_6
		{
		}
		
		[UmlElement("Association", Id="f5460853-bb46-4de8-afff-b8d9d54b3bf1")]
		public class Association_4
		{
		}
	}
	[UmlElement(Id="9992b2db-1174-4e86-92a5-056c03a94dcb")]
	public class Account : ILoopBack {

		public class AccountListAdapter : ObjectListAdapter, IAccountList
		{
			public AccountListAdapter(IList source) : 
					base(source)
			{
			}
			public Account this[int index]
			{
				get
				{
					return ((Account)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Account value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Account value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Account value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Account value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Account value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Account(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 14);
			public const int Status = Eco_FirstMember;
			public const int State = (Status + 1);
			public const int Addr2 = (State + 1);
			public const int Zip = (Addr2 + 1);
			public const int Phone = (Zip + 1);
			public const int FirstName = (Phone + 1);
			public const int Email = (FirstName + 1);
			public const int Id = (Email + 1);
			public const int Country = (Id + 1);
			public const int Addr1 = (Country + 1);
			public const int City = (Addr1 + 1);
			public const int LastName = (City + 1);
			public const int SignOn = (LastName + 1);
			public const int Profile = (SignOn + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Account(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="8c803b28-abcf-4a7d-98d1-855009b54548", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="77bf3f51-43f3-49bf-8574-527a7b42fa2c", Index=Eco_LoopbackIndices.Email)]
		public string Email
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, ((object)(value)));
			}
		}
		[UmlElement(Id="73f8b3e1-57ec-4568-b1f5-74fdc94ce90b", Index=Eco_LoopbackIndices.FirstName)]
		public string FirstName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.FirstName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.FirstName, ((object)(value)));
			}
		}
		[UmlElement(Id="f7957339-5f2e-4a0a-882a-aab498eae8bc", Index=Eco_LoopbackIndices.LastName)]
		public string LastName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LastName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LastName, ((object)(value)));
			}
		}
		[UmlElement(Id="060ca33e-4113-4c2e-b3a4-1e410442ddbe", Index=Eco_LoopbackIndices.Status)]
		public string Status
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Status)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Status, ((object)(value)));
			}
		}
		[UmlElement(Id="f43a8542-f840-4e17-8308-d0a0e44134ee", Index=Eco_LoopbackIndices.Addr1)]
		public string Addr1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Addr1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Addr1, ((object)(value)));
			}
		}
		[UmlElement(Id="452017b6-cc54-45fd-a923-9015488cddbe", Index=Eco_LoopbackIndices.Addr2)]
		public string Addr2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Addr2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Addr2, ((object)(value)));
			}
		}
		[UmlElement(Id="f47c2958-dbac-41ae-a8b2-5c07924659c3", Index=Eco_LoopbackIndices.City)]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}
		[UmlElement(Id="081136fb-b9a3-4e5a-a593-4bdeca52aef5", Index=Eco_LoopbackIndices.State)]
		public string State
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.State)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.State, ((object)(value)));
			}
		}
		[UmlElement(Id="6889da5a-e4f0-4ed1-9103-2c59b7471278", Index=Eco_LoopbackIndices.Zip)]
		public string Zip
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Zip)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Zip, ((object)(value)));
			}
		}
		[UmlElement(Id="e0b529f9-c130-4474-8b4a-97944d8e8b41", Index=Eco_LoopbackIndices.Country)]
		public string Country
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Country)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Country, ((object)(value)));
			}
		}
		[UmlElement(Id="6dd2231f-642a-412a-b614-ea0e30c68d99", Index=Eco_LoopbackIndices.Phone)]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.SignOn, Id="20c563dc-7c63-4969-bf55-26605d83e798")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_1), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public SignOn SignOn
		{
			get
			{
				return ((SignOn)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.SignOn)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.SignOn, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Profile, Id="bdf44067-3677-4421-b7a9-b64b46aa954b")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_2), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		[UmlTaggedValue("Eco.Embed", "False")]
		public Profile Profile
		{
			get
			{
				return ((Profile)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Profile)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Profile, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="c1fc4dfe-c1ab-4796-8222-6f0a2c197001")]
    public class Category : ILoopBack {

        public class CategoryListAdapter : ObjectListAdapter, ICategoryList
		{
			public CategoryListAdapter(IList source) : 
					base(source)
			{
			}
			public Category this[int index]
			{
				get
				{
					return ((Category)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Category value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Category value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Category value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Category value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Category value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Category(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 6);
			public const int Name = Eco_FirstMember;
			public const int Id = (Name + 1);
			public const int Descn = (Id + 1);
			public const int BannerData = (Descn + 1);
			public const int Products = (BannerData + 1);
			public const int Profile = (Products + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Category(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="479da26c-5e10-4fcc-a34d-e560ff902cea", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="2eb8fc08-b061-489a-b8d6-bb5988680afe", Index=Eco_LoopbackIndices.Name)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement(Id="f5d753d6-9300-4f36-af7a-03c8252f11b4", Index=Eco_LoopbackIndices.Descn)]
		public string Descn
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descn)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descn, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Products, Id="4bb87c7c-ccdd-40ab-acb0-55851a218b83")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.CategoryProducts), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProductList Products
		{
			get
			{
				return new Product.ProductListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Products))));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Profile, Id="9fd6aac9-87e6-42c3-a6ae-8ccc7cbfbffc")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_3), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IProfileList Profile
		{
			get
			{
				return new Profile.ProfileListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Profile))));
			}
		}
		[UmlElement(Id="fac3872d-412a-4e22-9e39-9d25a7094aca", Index=Eco_LoopbackIndices.BannerData)]
		public string BannerData
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BannerData)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BannerData, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="c8bf1805-f552-4f1c-835f-b93c8d22e567")]
    public class Inventory : ILoopBack {

        public class InventoryListAdapter : ObjectListAdapter, IInventoryList
		{
			public InventoryListAdapter(IList source) : 
					base(source)
			{
			}
			public Inventory this[int index]
			{
				get
				{
					return ((Inventory)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Inventory value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Inventory value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Inventory value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Inventory value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Inventory value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Inventory(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int Id = Eco_FirstMember;
			public const int Qty = (Id + 1);
			public const int Item = (Qty + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Inventory(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="9c2ad274-0c2b-445a-a3de-793f6947fe26", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="dbb5298c-338a-4cb4-84e8-0228f185ce31", Index=Eco_LoopbackIndices.Qty)]
		public int Qty
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Qty)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Qty, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Item, Id="96600bbf-a2ef-4f60-9a18-98e1b331af78")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_5), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		[UmlTaggedValue("Eco.Embed", "False")]
		public Item Item
		{
			get
			{
				return ((Item)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Item)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Item, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="977a482f-9e49-4414-9614-b5085875b8fb")]
    public class Item : ILoopBack {

        public class ItemListAdapter : ObjectListAdapter, IItemList
		{
			public ItemListAdapter(IList source) : 
					base(source)
			{
			}
			public Item this[int index]
			{
				get
				{
					return ((Item)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Item value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Item value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Item value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Item value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Item value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Item(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 12);
			public const int Attr1 = Eco_FirstMember;
			public const int Id = (Attr1 + 1);
			public const int Attr3 = (Id + 1);
			public const int Attr5 = (Attr3 + 1);
			public const int UnitCost = (Attr5 + 1);
			public const int Attr2 = (UnitCost + 1);
			public const int Status = (Attr2 + 1);
			public const int ListPrice = (Status + 1);
			public const int Attr4 = (ListPrice + 1);
			public const int Inventory = (Attr4 + 1);
			public const int Product = (Inventory + 1);
			public const int Supplier = (Product + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Item(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="2b989ebc-dcbb-4c7c-a89b-7af20be55adb", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="c6dad9f3-9c5f-4990-9595-e964f3445bf5", Index=Eco_LoopbackIndices.ListPrice)]
		public decimal ListPrice
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ListPrice)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ListPrice, ((object)(value)));
			}
		}
		[UmlElement(Id="61d345a5-62e1-4c04-87a8-7962158c5d2d", Index=Eco_LoopbackIndices.UnitCost)]
		public decimal UnitCost
		{
			get
			{
				return ((decimal)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UnitCost)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UnitCost, ((object)(value)));
			}
		}
		[UmlElement(Id="9aa1c4d4-72ca-4e4f-a509-6eb65862a3b1", Index=Eco_LoopbackIndices.Status)]
		public string Status
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Status)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Status, ((object)(value)));
			}
		}
		[UmlElement(Id="28c3d0af-1c4a-4dbd-9742-5366c736bcbe", Index=Eco_LoopbackIndices.Attr1)]
		public string Attr1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Attr1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Attr1, ((object)(value)));
			}
		}
		[UmlElement(Id="8f87f18d-b925-46cd-8856-e96105e3bb5a", Index=Eco_LoopbackIndices.Attr2)]
		public string Attr2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Attr2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Attr2, ((object)(value)));
			}
		}
		[UmlElement(Id="339fdfd4-dedd-488b-8ed5-231db3b31b87", Index=Eco_LoopbackIndices.Attr3)]
		public string Attr3
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Attr3)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Attr3, ((object)(value)));
			}
		}
		[UmlElement(Id="e0d1b8e2-0e1c-432d-98af-3e4fd42fe579", Index=Eco_LoopbackIndices.Attr4)]
		public string Attr4
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Attr4)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Attr4, ((object)(value)));
			}
		}
		[UmlElement(Id="40af7718-5048-43ad-8a67-d95b36743f95", Index=Eco_LoopbackIndices.Attr5)]
		public string Attr5
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Attr5)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Attr5, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Inventory, Id="b8c97cc9-72a0-4139-973b-a62d990f056d")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_5), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Inventory Inventory
		{
			get
			{
				return ((Inventory)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Inventory)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Inventory, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Product, Id="dd8ffaad-650f-4114-8ca1-30e04bce2317")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_6), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Product Product
		{
			get
			{
				return ((Product)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Product)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Product, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Supplier, Id="ee780594-7f3c-4708-876a-6dde79466fec")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_4), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Supplier Supplier
		{
			get
			{
				return ((Supplier)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Supplier)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Supplier, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="25e61c58-7684-4bff-a487-239d4c14c76c")]
    public class Product : ILoopBack {

        public class ProductListAdapter : ObjectListAdapter, IProductList
		{
			public ProductListAdapter(IList source) : 
					base(source)
			{
			}
			public Product this[int index]
			{
				get
				{
					return ((Product)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Product value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Product value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Product value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Product value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Product value)
			{
				this.Adaptee.Remove(value);
			}
		}

		#region Autogenerated ECO code
		
		#endregion Autogenerated ECO code

		#region AutoGenerated ECO code

		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

		public Product(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 5);
			public const int Id = Eco_FirstMember;
			public const int Name = (Id + 1);
			public const int Descn = (Name + 1);
			public const int Item = (Descn + 1);
			public const int Category = (Item + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}


        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Product(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="16ab5ec0-11a1-48cd-86ad-cb37f51c3803", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Category, Id="47196d8b-8cce-4338-bd72-e4c32c6fc8de")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.CategoryProducts), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Category Category
		{
			get
			{
				return ((Category)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Category)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Category, ((object)(value)));
			}
		}
		[UmlElement(Id="508e895b-1f1d-454d-b543-be049f8fce91", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement(Id="8024210d-aa55-4074-843b-0ede27ce2ff8", Index=Eco_LoopbackIndices.Descn)]
		public string Descn
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descn)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descn, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Item, Id="20248c6f-8fd4-45db-824e-6cd3796ef7c1")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_6), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IItemList Item
		{
			get
			{
				return new Item.ItemListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Item))));
			}
		}
    }
    [UmlElement(Id="0e82a600-e84b-4027-a4d0-f6c67fd7033b")]
    public class Profile : ILoopBack {

        public class ProfileListAdapter : ObjectListAdapter, IProfileList
		{
			public ProfileListAdapter(IList source) : 
					base(source)
			{
			}
			public Profile this[int index]
			{
				get
				{
					return ((Profile)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Profile value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Profile value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Profile value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Profile value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Profile value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Profile(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 6);
			public const int BannerOpt = Eco_FirstMember;
			public const int MyListOpt = (BannerOpt + 1);
			public const int Id = (MyListOpt + 1);
			public const int LangPref = (Id + 1);
			public const int Account = (LangPref + 1);
			public const int Category = (Account + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Profile(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="91b4608f-fb90-4b43-8de7-fda647dda036", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string Id
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="95996f73-e6c0-4ad5-8621-dcf7e938db68", Index=Eco_LoopbackIndices.LangPref)]
		public string LangPref
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.LangPref)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.LangPref, ((object)(value)));
			}
		}
		[UmlElement(Id="32ceeada-3cbc-4b37-b31c-fab0b79311eb", Index=Eco_LoopbackIndices.MyListOpt)]
		public int MyListOpt
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.MyListOpt)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.MyListOpt, ((object)(value)));
			}
		}
		[UmlElement(Id="13b249d1-7905-4394-801b-a3613b4dfd19", Index=Eco_LoopbackIndices.BannerOpt)]
		public int BannerOpt
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BannerOpt)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BannerOpt, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Account, Id="6be56645-58a3-4046-91fe-3663d339df74")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_2), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Account Account
		{
			get
			{
				return ((Account)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Account)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Account, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Category, Id="fad32b90-89c2-44b1-8d3c-79edba0cb1c4")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_3), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Category Category
		{
			get
			{
				return ((Category)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Category)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Category, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="d631aa1b-5af7-4bfd-8ba1-872ef0698cd4")]
    public class SignOn : ILoopBack {

        public class SignOnListAdapter : ObjectListAdapter, ISignOnList
		{
			public SignOnListAdapter(IList source) : 
					base(source)
			{
			}
			public SignOn this[int index]
			{
				get
				{
					return ((SignOn)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(SignOn value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(SignOn value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(SignOn value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, SignOn value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(SignOn value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public SignOn(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 3);
			public const int UserName = Eco_FirstMember;
			public const int Password = (UserName + 1);
			public const int Account = (Password + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public SignOn(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="078224b3-edbe-4889-bb3e-81fe4f6cf20f", Index=Eco_LoopbackIndices.UserName)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public string UserName
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.UserName)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.UserName, ((object)(value)));
			}
		}
		[UmlElement(Id="ffdada06-d31c-40d7-984a-c4c354f59508", Index=Eco_LoopbackIndices.Password)]
		public string Password
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Password)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Password, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Account, Id="67c90772-1f76-4c6e-8b16-85a2c1b27be5")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_1), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		[UmlTaggedValue("Eco.Embed", "False")]
		public Account Account
		{
			get
			{
				return ((Account)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Account)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Account, ((object)(value)));
			}
		}
    }
    [UmlElement(Id="422b8aae-297b-4e72-95ed-3765aa08af6e")]
    public class Supplier : ILoopBack {

        public class SupplierListAdapter : ObjectListAdapter, ISupplierList
		{
			public SupplierListAdapter(IList source) : 
					base(source)
			{
			}
			public Supplier this[int index]
			{
				get
				{
					return ((Supplier)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Supplier value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Supplier value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Supplier value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Supplier value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Supplier value)
			{
				this.Adaptee.Remove(value);
			}
		}

        #region AutoGenerated ECO code

        public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;

        public Supplier(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 10);
			public const int City = Eco_FirstMember;
			public const int Name = (City + 1);
			public const int Phone = (Name + 1);
			public const int Addr1 = (Phone + 1);
			public const int Zip = (Addr1 + 1);
			public const int State = (Zip + 1);
			public const int Status = (State + 1);
			public const int Id = (Status + 1);
			public const int Addr2 = (Id + 1);
			public const int Item = (Addr2 + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}

        public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}

        public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}

        protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}

        protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}

        #endregion Autogenerated ECO code

        public Supplier(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="c4e5e4d2-ae8d-4ce0-bbd8-d66cb0ab1245", Index=Eco_LoopbackIndices.Id)]
		[UmlTaggedValue("Eco.SaveAction", "Freeze")]
		public int Id
		{
			get
			{
				return ((int)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Id)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Id, ((object)(value)));
			}
		}
		[UmlElement(Id="b59169b8-a8d0-4392-b648-7e1dfe395242", Index=Eco_LoopbackIndices.Status)]
		public string Status
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Status)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Status, ((object)(value)));
			}
		}
		[UmlElement(Id="64fbf4d0-665c-450f-a3ca-fda5877c7f2a", Index=Eco_LoopbackIndices.Addr1)]
		public string Addr1
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Addr1)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Addr1, ((object)(value)));
			}
		}
		[UmlElement(Id="d39daf57-68e1-49e6-a1e4-45ed7884c372", Index=Eco_LoopbackIndices.Addr2)]
		public string Addr2
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Addr2)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Addr2, ((object)(value)));
			}
		}
		[UmlElement(Id="0eb7f083-9ff8-4885-af0a-e2eb412b1723", Index=Eco_LoopbackIndices.City)]
		public string City
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.City)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.City, ((object)(value)));
			}
		}
		[UmlElement(Id="b46b2571-dfa0-4438-80fa-734cd3ec435d", Index=Eco_LoopbackIndices.State)]
		public string State
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.State)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.State, ((object)(value)));
			}
		}
		[UmlElement(Id="91ee7ca7-786a-4c3f-98fc-6988844f01a0", Index=Eco_LoopbackIndices.Zip)]
		public string Zip
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Zip)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Zip, ((object)(value)));
			}
		}
		[UmlElement(Id="5ed445fb-d2d3-4444-a4ff-891c7fe8fd07", Index=Eco_LoopbackIndices.Phone)]
		public string Phone
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Phone)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Phone, ((object)(value)));
			}
		}
		[UmlElement(Id="1d6b137a-4f76-476f-9d8f-6f97ff27bdfc", Index=Eco_LoopbackIndices.Name)]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Item, Id="60f1440c-dc35-4f1f-a194-d5e475622697")]
		[UmlMetaAttribute("association", typeof(MSPetShopClassesPackage.Association_4), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IItemList Item
		{
			get
			{
				return new Item.ItemListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Item))));
			}
		}
	}
}
